using System.Collections.Generic;
using System.Linq;
using UnityEngine;
using Verse;
using Verse.AI;

namespace Therapy
{
    public class Building_Couch : Building
    {
        public Pawn CurOccupant { get { return GetCurOccupant(); } }

        public override Color DrawColor
        {
            get
            {
                if (def.MadeFromStuff)
                {
                    return base.DrawColor;
                }
                return DrawColorTwo;
            }
        }
        
        public Pawn GetCurOccupant()
        {
            if (!Spawned)
            {
                return null;
            }
            IntVec3 sleepingSlotPos = GetRestingSlotPos();
            List<Thing> list = Map.thingGrid.ThingsListAt(sleepingSlotPos);
            return list.OfType<Pawn>().Where(pawn => pawn.CurJob != null).FirstOrDefault(pawn => pawn.jobs.curDriver.layingDown == LayingDownState.LayingSurface);
        }

        public IntVec3 GetRestingSlotPos()
        {
            var index = 0;
            CellRect cellRect = this.OccupiedRect();
            if (Rotation == Rot4.North)
            {
                return new IntVec3(cellRect.minX + index, Position.y, cellRect.minZ);
            }
            if (Rotation == Rot4.East)
            {
                return new IntVec3(cellRect.minX, Position.y, cellRect.maxZ - index);
            }
            if (Rotation == Rot4.South)
            {
                return new IntVec3(cellRect.minX + index, Position.y, cellRect.maxZ);
            }
            return new IntVec3(cellRect.maxX, Position.y, cellRect.maxZ - index);
        }
    }
}
